<!DOCTYPE html>
<html lang="zxx">

<head>
    <meta charset="UTF-8">
    <meta name="description" content="Loanday Template">
    <meta name="keywords" content="Loanday, unica, creative, html">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Dubai Treasury Bank</title>

    <!-- Google Font -->
    <link href="https://fonts.googleapis.com/css2?family=Lato:wght@300;400;700;900&display=swap" rel="stylesheet">

    <!-- Css Styles -->
    <link rel="stylesheet" href="css/bootstrap.min.css" type="text/css">
    <link rel="stylesheet" href="css/font-awesome.min.css" type="text/css">
    <link rel="stylesheet" href="css/elegant-icons.css" type="text/css">
    <link rel="stylesheet" href="css/nice-select.css" type="text/css">
    <link rel="stylesheet" href="css/magnific-popup.css" type="text/css">
    <link rel="stylesheet" href="css/jquery-ui.min.css" type="text/css">
    <link rel="stylesheet" href="css/owl.carousel.min.css" type="text/css">
    <link rel="stylesheet" href="css/slicknav.min.css" type="text/css">
    <link rel="stylesheet" href="css/style.css" type="text/css">
</head>

<body>
    <!-- Page Preloder -->
    <div id="preloder">
        <div class="loader"></div>
    </div>

    <!-- Offcanvas Menu Begin -->
    <div class="offcanvas-menu-overlay"></div>
    <div class="offcanvas-menu-wrapper">
        <div class="offcanvas__search">
            <i class="fa fa-search search-switch"></i>
        </div>
        <div class="offcanvas__logo">
            <a href="./index.html"><img src="img/logo.png" alt=""></a>
        </div>
        <nav class="offcanvas__menu mobile-menu">
            <ul>
                <li class="active"><a href="./index.html">Home</a></li>
                <li><a href="./about.html">About</a></li>
                <li><a href="./contact.html">Contact</a></li>
            </ul>
        </nav>
        <div id="mobile-menu-wrap"></div>
        <ul class="offcanvas__widget">
            <li><i class="fa fa-map-marker"></i> 96 Ernser Vista Suite 437, NY, US</li>
            <li><i class="fa fa-phone"></i> (123) 456-78-910</li>
            <li><i class="fa fa-envelope"></i> Info@dubaitreasurybank.com</li>
        </ul>
        <!-- <div class="offcanvas__language">
            <img src="img/flag.png" alt="">
            <span>English</span>
            <i class="fa fa-angle-down"></i>
            <ul>
                <li><a href="#">English</a></li>
                <li><a href="#">Bangla</a></li>
            </ul>
        </div> -->
    </div>
    <!-- Offcanvas Menu End -->

    <!-- Header Section Begin -->
    <header class="header">
        <div class="header__top">
            <div class="container">
                <div class="row">
                    <div class="col-lg-9">
                        <ul class="header__top__widget">
                            <li><i class="fa fa-map-marker"></i> 96 Ernser Vista Suite 437, NY, US</li>
                            <li><i class="fa fa-phone"></i> (123) 456-78-910</li>
                            <li><i class="fa fa-envelope"></i>Info@dubaitreasurybank.com</li>
                        </ul>
                    </div>
                    <!-- <div class="col-lg-3">
                        <div class="header__top__language">
                            <img src="img/flag.png" alt="">
                            <span>English</span>
                            <i class="fa fa-angle-down"></i>
                            <ul>
                                <li><a href="#">English</a></li>
                                <li><a href="#">Bangla</a></li>
                            </ul>
                        </div>
                    </div> -->
                </div>
            </div>
        </div>
        <div class="container">
            <div class="row">
                <div class="col-lg-3">
                    <div class="header__logo">
                        <a href="./index.html"><img src="img/logo.png" alt=""></a>
                    </div>
                </div>
                <div class="col-lg-9">
                    <div class="header__nav">
                        <nav class="header__menu">
                            <ul>
                                <li><a href="./index.html">Home</a></li>
                                <li class="active"><a href="./about.html">About</a></li>
                                <li><a href="./contact.html">Contact</a></li>
                            </ul>
                        </nav>
                        <div class="header__search">
                            <i class="fa fa-search search-switch"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="canvas__open">
                <span class="fa fa-bars"></span>
            </div>
        </div>
    </header>
    <!-- Header Section End -->

    <!-- Breadcrumb Section Begin -->
    <div class="breadcrumb-option set-bg" data-setbg="img/breadcrumb/breadcrumb-bg.jpg">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 text-center">
                    <div class="breadcrumb__text">
                        <h2>About Us</h2>
                        <div class="breadcrumb__links">
                            <a href="./index.html">Home</a>
                            <span>About</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumb Section End -->

    <!-- About Section Begin -->
    <section class="about spad">
        <div class="container">
            <div class="about__content">
                <div class="row">
                    <div class="col-lg-5">
                        <div class="about__img">
                            <img src="img/about/about.jpg" alt="">
                            <a href="https://www.youtube.com/watch?v=RpvAmG1NNN0"
                                class="play-btn video-popup"><img src="img/about/video-play.png" alt=""></a>
                        </div>
                    </div>
                    <div class="col-lg-6 offset-lg-1">
                        <div class="about__text">
                            <h2>Welcome To Dubai Treasury Bank.</h2>
                            <h4>We Are Much More Than Banking</h4>
                            <p class="first_para">Where trust, innovation, and financial excellence come together. </p>
                            <p class="last_para">We provide secure, customer-focused banking solutions designed to 
                                support personal and business growth. With advanced technology, transparent services, 
                                and dedicated professionals, we are committed to delivering reliable financial 
                                experiences that empower your future.</p>
                            <a href="contact.html" class="primary-btn">Contact Us</a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-4 col-md-4">
                    <div class="about__item">
                        <h4>Our Vision</h4>
                        <p>Our vision is to become a globally trusted banking institution, 
                            recognized for innovation, security, and customer excellence, 
                            delivering sustainable financial solutions that empower individuals 
                            and businesses, strengthen economies, and create long-term value 
                            across diverse markets worldwide.</p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-4">
                    <div class="about__item">
                        <h4>Our Mission</h4>
                        <p>Our mission is to provide secure, efficient, and customer-focused banking services through advanced technology,
                        transparent practices, and expert support, enabling clients to manage finances confidently, achieve financial goals, and
                        experience seamless, reliable banking at every stage.</p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-4">
                    <div class="about__item">
                        <h4>Our Value</h4>
                        <p>Our values are built on trust, integrity, innovation, and accountability. We prioritize customer satisfaction, ethical
                        practices, data security, and continuous improvement, fostering strong relationships and delivering consistent,
                        high-quality financial services that support growth, stability, and long-term success.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- About End -->

    <!-- History Section Begin -->
    <section class="history spad set-bg" data-setbg="img/history/history-bg.jpg">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-title">
                        <h2>Our History</h2>
                        <p>Lets Take A Quick Look At What We Have Become Over The Years, From Establishment Till Date</p>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="history__img">
                        <img src="img/history/history-img.jpg" alt="">
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="history__text nice-scroll">
                        <div class="history__item">
                            <div class="history__indicator"></div>
                            <span>25th, March 1974</span>
                            <h4>Dubai Treasury Bank Was Esterblished</h4>
                            <p>The Dubai Treasury Bank was established, laying strong foundations for trusted, secure, and innovative banking services
                            worldwide excellence.</p>
                        </div>
                        <div class="history__item">
                            <div class="history__indicator"></div>
                            <span>12th, July 1995</span>
                            <h4>Opened Branches In States Of UAE</h4>
                            <p>Achieved nationwide expansion by opening branches across all UAE states, strengthening accessibility, customer trust,
                            and market leadership.</p>
                        </div>
                        <div class="history__item">
                            <div class="history__indicator"></div>
                            <span>25th, March 2012</span>
                            <h4>Opening More Branches In Other Countries</h4>
                            <p>Expanded internationally, opening major branches across Islamic nations, reinforcing global presence, financial
                            inclusion, and cross-border banking excellence.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- History Section End -->

    <!-- Choose Section Begin -->
    <section class="choose spad">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-title">
                        <h2>Why People Choose Us</h2>
                        <p>There's always a reaason to trust an institution amongst all, and that is because we offer:</p>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-4 col-md-4 col-sm-6">
                    <div class="choose__item">
                        <img src="img/choose/choose-1.png" alt="">
                        <h5>Transparent Operations</h5>
                        <p>Clear policies, fair pricing, and honest communication build lasting customer confidence.</p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-4 col-sm-6">
                    <div class="choose__item">
                        <img src="img/choose/choose-2.png" alt="">
                        <h5>Advanced Security</h5>
                        <p>Strong encryption and fraud protection safeguard every transaction and account.</p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-4 col-sm-6">
                    <div class="choose__item">
                        <img src="img/choose/choose-3.png" alt="">
                        <h5>Innovative Banking Solutions</h5>
                        <p>Modern digital platforms ensure fast, convenient, and efficient financial management.</p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-4 col-sm-6">
                    <div class="choose__item">
                        <img src="img/choose/choose-4.png" alt="">
                        <h5>Customer-Centered Service</h5>
                        <p>We prioritize personalized solutions that meet individual and business financial needs.</p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-4 col-sm-6">
                    <div class="choose__item">
                        <img src="img/choose/choose-5.png" alt="">
                        <h5>Trusted Reliability</h5>
                        <p>Thousands of customers rely on our secure and proven banking systems.</p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-4 col-sm-6">
                    <div class="choose__item">
                        <img src="img/choose/choose-6.png" alt="">
                        <h5>Quick Account Process</h5>
                        <p>Open your account effortlessly with minimal documentation and fast verification.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Choose Section End -->

    <!-- Call Section Begin -->
    <section class="call spad set-bg" data-setbg="img/call-bg.jpg">
        <div class="container">
            <div class="row">
                <div class="col-lg-5 col-md-6">
                    <div class="call__text">
                        <div class="section-title">
                            <h2>Request A Call Back</h2>
                            <p>Posters had been a very beneficial marketing tool because it had paved to deliver an
                                effective message that conveyed customer’s attention.</p>
                        </div>
                        <a href="#">Contact Us</a>
                    </div>
                </div>
                <div class="col-lg-6 offset-lg-1 col-md-6">
                    <form action="#" class="call__form">
                        <div class="row">
                            <div class="col-lg-6">
                                <input type="text" placeholder="Name">
                            </div>
                            <div class="col-lg-6">
                                <input type="text" placeholder="Email">
                            </div>
                            <div class="col-lg-6">
                                <input type="text" placeholder="Phone">
                            </div>
                            <div class="col-lg-6">
                                <select>
                                    <option value="">Choose Our Services</option>
                                </select>
                            </div>
                        </div>
                        <button type="submit" class="site-btn">Submit</button>
                    </form>
                </div>
            </div>
        </div>
    </section>
    <!-- Call Section End -->

    <!-- Team Section Begin -->

    <!-- Team Section End -->

    <!-- Contact Begin -->
    <div class="contact-widget set-bg" data-setbg="img/contact-widget.jpg">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-md-6">
                    <div class="row">
                        <div class="col-lg-6 col-md-6">
                            <div class="contact__widget__item">
                                <h4>New York Office</h4>
                                <p>917 Atlantic Lane, Strongsville, NY, United State</p>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6">
                            <div class="contact__widget__item">
                                <h4>New Jersey Office</h4>
                                <p>1 Walnut Court, East Orange, NJ, United State</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6">
                    <div class="contact__widget__phone">
                        <span>Contact Us Now!</span>
                        <h2>(+12) 345-678-910</h2>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Contact End -->

    <!-- Footer Section Begin -->
    <footer class="footer">
        <div class="container">
            <div class="row">
                <div class="col-lg-3 col-md-6 col-sm-6">
                    <div class="footer__about">
                        <div class="footer__logo">
                            <a href="./index.html"><img src="img/footer-logo.png" alt=""></a>
                        </div>
                        <p> There is no substitute for your own
                            work and effort in succeeding in this business.</p>
                    </div>
                </div>
                <div class="col-lg-2 offset-lg-1 col-md-3 col-sm-6">
                    <div class="footer__widget">
                        <h5>Services</h5>
                        <div class="footer__widget">
                            <ul>
                                <li><a href="#">Personal Loans</a></li>
                                <li><a href="#">Business Loans</a></li>
                                <li><a href="#">Online Cash Loans</a></li>
                                <li><a href="#">Cash Advance</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-lg-2 col-md-3 col-sm-6">
                    <div class="footer__widget">
                        <h5>Socials</h5>
                        <div class="footer__widget footer__widget--social">
                            <ul>
                                <li><a href="#"><i class="fa fa-facebook"></i> Facebook</a></li>
                                <li><a href="#"><i class="fa fa-instagram"></i> Instagram</a></li>
                                <li><a href="#"><i class="fa fa-twitter"></i> Twitter</a></li>
                                <li><a href="#"><i class="fa fa-skype"></i> Skype</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 offset-lg-1 col-md-6 col-sm-6">
                    <div class="footer__widget footer__widget--address">
                        <h5>Open Hours</h5>
                        <p>We work all days a week, Please contact us for any inquiry.</p>
                        <ul>
                            <li>Monday - Friday: 11:00 am - 8:00 pm</li>
                            <li>Saturday: 10:00 am - 6:00 pm</li>
                            <li>Sunday: 11:00 am - 6:00 pm</li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="footer__copyright">
                <div class="row">
                    <div class="col-lg-6 col-md-6">
                        <ul class="footer__copyright__links">
                            <li><a href="#">Terms of use</a></li>
                            <li><a href="#">Privacy Policy</a></li>
                            <li><a href="#">Community</a></li>
                        </ul>
                    </div>

                </div>
            </div>
        </div>
    </footer>
    <!-- Footer Section End -->

    <!-- Search Begin -->
    <div class="search-model">
        <div class="h-100 d-flex align-items-center justify-content-center">
            <div class="search-close-switch">+</div>
            <form class="search-model-form">
                <input type="text" id="search-input" placeholder="Search here.....">
            </form>
        </div>
    </div>
    <!-- Search End -->

    <!-- Js Plugins -->
    <script src="js/jquery-3.3.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/jquery.nice-select.min.js"></script>
    <script src="js/jquery-ui.min.js"></script>
    <script src="js/jquery.nicescroll.min.js"></script>
    <script src="js/jquery.magnific-popup.min.js"></script>
    <script src="js/jquery.slicknav.js"></script>
    <script src="js/owl.carousel.min.js"></script>
    <script src="js/main.js"></script>
</body>

</html>