<?php
// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
?>


<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cards | Dubai Treasury Bank</title>

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

    <!-- CSS -->
    <link rel="stylesheet" href="card.css">
</head>

<body>

    <div class="app">

        <!-- Header -->
        <div class="top-header">
            <a href="dashboard.php" class="back-icon">
                <i class="bi bi-arrow-left"></i>
            </a>
            <h5>My Card / بطاقتي</h5>
            <span>Manage your card</span>
        </div>

        <div class="page-content">

            <!-- VALVE CARD -->
            <div class="valve-card">

                <!-- WATERMARK -->
                <div class="card-watermark">🌍</div>

                <!-- NETWORK LOGO -->
                <div class="valve-logo">VALVE</div>

                <!-- BANK NAME -->
                <div class="bank-name">Dubai Treasury Bank</div>

                <!-- CHIP -->
                <div class="chip-row">
                    <div class="chip">
                        <span></span><span></span><span></span><span></span>
                    </div>
                    <i class="bi bi-wifi contactless"></i>
                </div>

                <!-- NUMBER -->
                <div class="card-number">
                    5278&nbsp;&nbsp;9012&nbsp;&nbsp;3456&nbsp;&nbsp;8890
                </div>

                <!-- FOOTER -->
                <div class="card-footer">
                    <div>
                        <small>Card Holder</small>
                        <strong>EMMANUEL IKECHUKWU</strong>
                    </div>
                    <div>
                        <small>Expiry</small>
                        <strong>08/28</strong>
                    </div>
                </div>

            </div>

            <!-- BACK OF CARD -->
            <div class="valve-card back-card">
            
                <!-- MAGNETIC STRIP -->
                <div class="magnetic-strip"></div>
            
                <!-- SIGNATURE + CVV -->
                <div class="back-row">
                    <div class="signature-box">
                        <span>Signature</span>
                        <div></div>
                    </div>
            
                    <div class="cvv-box">
                        <span>CVV</span>
                        <strong>342</strong>
                    </div>
                </div>
            
                <!-- INFO TEXT -->
                <div class="back-info">
                    This card is issued by Dubai Treasury Bank. Use for ATM withdrawals, POS payments, and online transactions.
                </div>
            
                <!-- BANK NAME -->
                <div class="back-bank">Dubai Treasury Bank</div>
            
            </div>

            <!-- INFO -->
            <div class="info-card">
                <h6>Valve Debit Card / بطاقة ديبيت</h6>
                <p>
                    Your Valve debit card is enabled for secure Local payments, ATM withdrawals,
                    and everyday transactions Locally ONLY!.
                </p>
            </div>

            <div class="info-card">
                <h6>Card Technology / تقنية البطاقة</h6>
                <ul class="feature-list">
                    <li><i class="bi bi-globe"></i> NO Global acceptance!</li>
                    <li><i class="bi bi-shield-lock"></i> Advanced EMV security</li>
                    <li><i class="bi bi-cash"></i> ATM withdrawals worldwide</li>
                    <li><i class="bi bi-cpu"></i> Smart chip technology</li>
                </ul>
            </div>

            <button class="primary-btn">Manage Card / إدارة البطاقة</button>

        </div>

    </div>

    <!-- Bottom Nav -->
<div class="bottom-nav">
    <div>
        <a href="dashboard.php"><i class="bi bi-house-fill"></i></a>
        <a href="#"><i class="bi bi-bar-chart"></i></a>
        <a href="card.php"><i class="bi bi-credit-card active"></i></a>
        <a href="user_details.php"><i class="bi bi-person"></i></a>
    </div>
</div>

</body>

</html>
