<?php
session_start();

/* =========================
   AUTH CHECK
========================= */
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

/* =========================
   DATABASE CONNECTION
========================= */
$conn = mysqli_connect("localhost", "root", "", "dubai_treasury_bank");

if (!$conn) {
    die("Database connection failed: " . mysqli_connect_error());
}

/* =========================
   FETCH USER DATA
========================= */
$user_id = $_SESSION['user_id'];

$query = "SELECT * FROM users WHERE id = '$user_id' LIMIT 1";
$result = mysqli_query($conn, $query);

if (!$result || mysqli_num_rows($result) !== 1) {
    die("User not found");
}

$user = mysqli_fetch_assoc($result);

/* =========================
   PREPARE DATA
========================= */
$full_name      = $user['full_name'];
$account_number = $user['account_number'];
$account_balance = number_format($user['account_balance'], 2);
$kyc_status     = $user['kyc_status'];

/* Mask account number (**** 2481 style) */
$masked_account = "**** " . substr($account_number, -4);
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Dubai Treasury Bank</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Custom CSS -->
    <link rel="stylesheet" href="stlye_dash.css">
    <link rel="stylesheet" href="user_detail.css">
</head>

<body>

<div class="app">

    <!-- Header -->
    <div class="top-header">
        <div>
            <small>أهلاً بعودتك</small>
            <h4><?php echo htmlspecialchars($full_name); ?></h4>
        </div>
        <i class="bi bi-bell"></i>
    </div>

    <!-- Profile Card -->
    <div class="profile-card">
        <div class="profile-img">
            <i class="bi bi-person-circle"></i>
        </div>

        <div class="profile-info">
            <h4><?php echo htmlspecialchars($full_name); ?></h4>
            <p><strong>Account Number:</strong> <?php echo htmlspecialchars($account_number); ?></p>
            <p><strong>نوع الحساب:</strong> Premium</p>
        </div>
    </div>

    <!-- Wallet Card -->
    <div class="wallet-card">
        <p>إجمالي الرصيد</p>
        <h2>AED <?php echo $account_balance; ?></h2>
        <div class="wallet-footer">
            <span>Dubai Treasury Bank</span>
            <span><?php echo htmlspecialchars($account_number); ?></span>
        </div>
    </div>

    <!-- Analytics (STATIC FOR NOW) -->
    <div class="analytics">
        <div class="analytic-card">
            <small>الدخل</small>
            <h6>+ AED 776,320,000</h6>
        </div>
        <div class="analytic-card">
            <small>مصروفات</small>
            <h6>- AED 945,445,850</h6>
        </div>
    </div>

    <!-- Actions -->
    <div class="action-grid">

        <a href="transfer.php" class="action-box">
            <i class="bi bi-send"></i>
            <span>تحويل</span>
        </a>

        <a href="airtime.php" class="action-box">
            <i class="bi bi-telephone"></i>
            <span>رصيد</span>
        </a>

        <a href="data.php" class="action-box">
            <i class="bi bi-wifi"></i>
            <span>إنترنت</span>
        </a>

        <a href="bills.php" class="action-box">
            <i class="bi bi-receipt"></i>
            <span>فواتير</span>
        </a>

        <a href="card.php" class="action-box">
            <i class="bi bi-credit-card"></i>
            <span>بطاقة</span>
        </a>

        <a href="#" class="action-box">
            <i class="bi bi-grid"></i>
            <span>المزيد</span>
        </a>

    </div>

    <!-- Transactions (STATIC PLACEHOLDER) -->
    <div class="transaction-section">
        <div class="section-title">
            <h6>المعاملات الأخيرة</h6>
            <small>View all</small>
        </div>

        <div class="transaction-item">
            <i class="bi bi-arrow-up-right debit"></i>
            <div class="details">
                <strong>Transfer to Ahmed</strong>
                <small>10 Jan 2026</small>
            </div>
            <span class="debit">- AED 112,000</span>
        </div>

        <div class="transaction-item">
            <i class="bi bi-arrow-down-left credit"></i>
            <div class="details">
                <strong>Salary Credit</strong>
                <small>08 Jan 2026</small>
            </div>
            <span class="credit">+ AED 300,000,000</span>
        </div>

        <div class="transaction-item">
            <i class="bi bi-lightning debit"></i>
            <div class="details">
                <strong>Electricity Bill</strong>
                <small>05 Jan 2026</small>
            </div>
            <span class="debit">- AED 10,850</span>
        </div>
    </div>

</div>

<!-- Bottom Navigation -->
<div class="bottom-nav">
    <div>
        <a href="dashboard.php"><i class="bi bi-house-fill active"></i></a>
        <a href="#"><i class="bi bi-bar-chart"></i></a>
        <a href="card.php"><i class="bi bi-credit-card"></i></a>
        <a href="user_details.php"><i class="bi bi-person"></i></a>
    </div>
</div>

</body>
</html>
