<?php
// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
?>


<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Data | Dubai Treasury Bank</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
    <link rel="stylesheet" href="css/apps.css">
</head>

<body>

    <div class="app">
        <div class="top-header">
            <a href="dashboard.php" class="back-icon">
                <i class="bi bi-arrow-left"></i>
            </a>
            <h5>Data / بيانات</h5>
            <span>Buy data bundles</span>
        </div>

        <div class="page-content">

            <div class="balance-card">
                <small>Available Balance</small>
                <h2>AED 125,450.00</h2>
            </div>

            <div class="form-card">
                <label>Phone Number / رقم الهاتف</label>
                <input id="phoneNumber" class="form-control" placeholder="Enter phone number">
            </div>

            <div class="form-card">
                <label>Data Bundle / باقة بيانات</label>
                <select id="bundle" class="form-control">
                    <option value="">Select bundle</option>
                    <option value="1GB">1GB - AED 5</option>
                    <option value="2GB">2GB - AED 8</option>
                    <option value="5GB">5GB - AED 15</option>
                    <option value="10GB">10GB - AED 25</option>
                </select>
            </div>

            <button class="primary-btn" id="continueBtn">Continue / متابعة</button>

        </div>
    </div>

    <div class="modal-overlay" id="pinModal">
        <div class="modal">
            <div class="modal-header">
                <h5>Enter PIN / أدخل رقمك السري</h5>
                <span class="close-btn" id="closeModal">&times;</span>
            </div>

            <p class="modal-sub">Enter your 4-digit PIN to continue</p>

            <div class="input-group">
                <label>PIN</label>
                <input type="password" id="pinInput" maxlength="4" readonly>
            </div>

            <div class="dialpad">
                <button class="dial-btn">1</button>
                <button class="dial-btn">2</button>
                <button class="dial-btn">3</button>
                <button class="dial-btn">4</button>
                <button class="dial-btn">5</button>
                <button class="dial-btn">6</button>
                <button class="dial-btn">7</button>
                <button class="dial-btn">8</button>
                <button class="dial-btn">9</button>
                <button class="dial-btn">C</button>
                <button class="dial-btn">0</button>
                <button class="dial-btn">OK</button>
            </div>

            <button class="primary-btn modal-btn" id="verifyBtn">Verify / تأكيد</button>
        </div>
    </div>

    <!-- Bottom Nav -->
<div class="bottom-nav">
    <div>
        <a href="dashboard.php"><i class="bi bi-house-fill active"></i></a>
        <a href="#"><i class="bi bi-bar-chart"></i></a>
        <a href="card.php"><i class="bi bi-credit-card"></i></a>
        <a href="user_details.php"><i class="bi bi-person"></i></a>
    </div>
</div>

    <script src="js/data.js"></script>
</body>

</html>
