document.addEventListener("DOMContentLoaded", () => {

    const toggleLogin = document.getElementById("toggleLogin");
    const toggleSignup = document.getElementById("toggleSignup");

    if (toggleLogin) {
        const loginPass = document.getElementById("loginPass");
        toggleLogin.addEventListener("click", () => {
            loginPass.type = loginPass.type === "password" ? "text" : "password";
            toggleLogin.textContent = loginPass.type === "password" ? "Show" : "Hide";
        });
    }

    if (toggleSignup) {
        const signupPass = document.getElementById("signupPass");
        toggleSignup.addEventListener("click", () => {
            signupPass.type = signupPass.type === "password" ? "text" : "password";
            toggleSignup.textContent = signupPass.type === "password" ? "Show" : "Hide";
        });
    }

    // Basic login validation
    const loginBtn = document.getElementById("loginBtn");
    if (loginBtn) {
        loginBtn.addEventListener("click", () => {
            const user = document.getElementById("loginUser").value.trim();
            const pass = document.getElementById("loginPass").value.trim();

            if (!user || !pass) {
                alert("Please fill all fields.");
                return;
            }

            alert("Login Successful!");
            window.location.href = "index.html";
        });
    }

    // Basic signup validation
    const signupBtn = document.getElementById("signupBtn");
    if (signupBtn) {
        signupBtn.addEventListener("click", () => {
            const name = document.getElementById("fullName").value.trim();
            const email = document.getElementById("email").value.trim();
            const phone = document.getElementById("phone").value.trim();
            const pass = document.getElementById("signupPass").value.trim();

            if (!name || !email || !phone || !pass) {
                alert("Please fill all fields.");
                return;
            }

            alert("Account Created Successfully!");
            window.location.href = "login.html";
        });
    }
});
