document.addEventListener("DOMContentLoaded", () => {

    const continueBtn = document.getElementById("continueBtn");
    const modal = document.getElementById("pinModal");
    const closeModal = document.getElementById("closeModal");
    const pinInput = document.getElementById("pinInput");

    const billerName = document.getElementById("billerName");
    const invoiceNumber = document.getElementById("invoiceNumber");
    const amount = document.getElementById("amount");

    continueBtn.addEventListener("click", () => {
        if (billerName.value.trim() === "" || invoiceNumber.value.trim() === "" || amount.value.trim() === "") {
            alert("Please fill all fields.");
            return;
        }
        modal.style.display = "flex";
    });

    closeModal.addEventListener("click", () => {
        modal.style.display = "none";
        pinInput.value = "";
    });

    document.querySelectorAll(".dial-btn").forEach(btn => {
        btn.addEventListener("click", () => {
            const value = btn.textContent;
            if (value === "C") { pinInput.value = ""; return; }
            if (value === "OK") { alert("PIN entered: " + pinInput.value); return; }
            if (pinInput.value.length < 4) { pinInput.value += value; }
        });
    });

    document.getElementById("verifyBtn").addEventListener("click", () => {
        if (pinInput.value.length === 4) {
            alert("Payment Successful!\nBiller: " + billerName.value + "\nInvoice: " + invoiceNumber.value + "\nAmount: AED " + amount.value);
            modal.style.display = "none";
            pinInput.value = "";
            billerName.value = "";
            invoiceNumber.value = "";
            amount.value = "";
        } else {
            alert("Enter 4-digit PIN");
        }
    });

});
