document.addEventListener("DOMContentLoaded", () => {

    const continueBtn = document.getElementById("continueBtn");
    const modal = document.getElementById("pinModal");
    const closeModal = document.getElementById("closeModal");
    const pinInput = document.getElementById("pinInput");

    const phoneNumber = document.getElementById("phoneNumber");
    const bundle = document.getElementById("bundle");

    continueBtn.addEventListener("click", () => {
        if (phoneNumber.value.trim() === "" || bundle.value === "") {
            alert("Please fill all fields.");
            return;
        }
        modal.style.display = "flex";
    });

    closeModal.addEventListener("click", () => {
        modal.style.display = "none";
        pinInput.value = "";
    });

    document.querySelectorAll(".dial-btn").forEach(btn => {
        btn.addEventListener("click", () => {
            const value = btn.textContent;
            if (value === "C") { pinInput.value = ""; return; }
            if (value === "OK") { alert("PIN entered: " + pinInput.value); return; }
            if (pinInput.value.length < 4) { pinInput.value += value; }
        });
    });

    document.getElementById("verifyBtn").addEventListener("click", () => {
        if (pinInput.value.length === 4) {
            alert("Data Purchase Successful!\nPhone: " + phoneNumber.value + "\nBundle: " + bundle.value);
            modal.style.display = "none";
            pinInput.value = "";
            phoneNumber.value = "";
            bundle.value = "";
        } else {
            alert("Enter 4-digit PIN");
        }
    });

});
