const transactions = [
    {
        type: "Bank Transfer",
        merchant: "Dubai Treasury Bank",
        amount: "AED 50,000",
        date: "05 Jan 2026 - 09:20 AM",
        ref: "TXN-001A",
        status: "success"
    },
    {
        type: "Electricity Bill",
        merchant: "DEWA",
        amount: "AED 8,500",
        date: "04 Jan 2026 - 11:05 AM",
        ref: "TXN-002B",
        status: "success"
    },
    {
        type: "Water Bill",
        merchant: "DEWA Water",
        amount: "AED 3,200",
        date: "03 Jan 2026 - 08:15 PM",
        ref: "TXN-003C",
        status: "success"
    },
    {
        type: "Airtime Purchase",
        merchant: "Etisalat",
        amount: "AED 2,000",
        date: "02 Jan 2026 - 06:30 PM",
        ref: "TXN-004D",
        status: "success"
    },
    {
        type: "Data Subscription",
        merchant: "Du",
        amount: "AED 3,500",
        date: "02 Jan 2026 - 04:50 PM",
        ref: "TXN-005E",
        status: "success"
    },
    {
        type: "Utility Bill",
        merchant: "Chiller",
        amount: "AED 6,700",
        date: "01 Jan 2026 - 02:10 PM",
        ref: "TXN-006F",
        status: "success"
    },
    {
        type: "Bank Transfer",
        merchant: "Dubai Treasury Bank",
        amount: "AED 120,000",
        date: "30 Dec 2025 - 05:20 PM",
        ref: "TXN-007G",
        status: "pending"
    },
    {
        type: "Airtime Purchase",
        merchant: "Etisalat",
        amount: "AED 1,500",
        date: "29 Dec 2025 - 09:30 AM",
        ref: "TXN-008H",
        status: "success"
    },
    {
        type: "Data Subscription",
        merchant: "Du",
        amount: "AED 5,000",
        date: "28 Dec 2025 - 07:40 PM",
        ref: "TXN-009I",
        status: "success"
    },
    {
        type: "Electricity Bill",
        merchant: "DEWA",
        amount: "AED 10,000",
        date: "27 Dec 2025 - 12:20 PM",
        ref: "TXN-010J",
        status: "success"
    }
];

function renderTransactions() {
    const list = document.getElementById("transactionList");
    list.innerHTML = "";

    transactions.forEach(tran => {
        const item = document.createElement("div");
        item.classList.add("transaction-item");

        item.innerHTML = `
            <div class="trans-left">
                <div class="trans-type">${tran.type}</div>
                <div class="trans-merchant">${tran.merchant}</div>
                <div class="trans-date">${tran.date}</div>
            </div>
            <div class="trans-right">
                <div class="trans-amount">${tran.amount}</div>
                <div class="trans-ref">Ref: ${tran.ref}</div>
                <div class="trans-status ${tran.status}">${tran.status}</div>
            </div>
        `;

        list.appendChild(item);
    });
}

renderTransactions();
