document.addEventListener("DOMContentLoaded", () => {
    const passwordInput = document.getElementById("securePassword");
    const toggleBtn = document.getElementById("togglePassword");
    const verifyBtn = document.getElementById("verifyBtn");
    const errorMsg = document.getElementById("errorMsg");

    // Toggle password visibility
    toggleBtn.addEventListener("click", () => {
        if (passwordInput.type === "password") {
            passwordInput.type = "text";
            toggleBtn.textContent = "Hide";
        } else {
            passwordInput.type = "password";
            toggleBtn.textContent = "Show";
        }
    });

    // Verify password
    verifyBtn.addEventListener("click", () => {
        const password = passwordInput.value.trim();

        if (password.length < 8) {
            errorMsg.textContent = "Password must be at least 8 characters.";
            return;
        }

        // If password is correct
        alert("Verified! You may proceed.");
        errorMsg.textContent = "";
        passwordInput.value = "";
    });
});
