document.addEventListener("DOMContentLoaded", () => {

    const continueBtn = document.getElementById("continueBtn");
    const modal = document.getElementById("pinModal");
    const closeModal = document.getElementById("closeModal");
    const pinInput = document.getElementById("pinInput");

    const accountNumber = document.getElementById("accountNumber");
    const amount = document.getElementById("amount");

    // open PIN modal when continue is clicked
    continueBtn.addEventListener("click", () => {

        if (accountNumber.value.trim() === "" || amount.value.trim() === "") {
            alert("Please fill all fields.");
            return;
        }

        modal.style.display = "flex";
    });

    // close modal
    closeModal.addEventListener("click", () => {
        modal.style.display = "none";
        pinInput.value = "";
    });

    // dialpad input
    document.querySelectorAll(".dial-btn").forEach(btn => {
        btn.addEventListener("click", () => {
            const value = btn.textContent;

            if (value === "C") {
                pinInput.value = "";
                return;
            }

            if (value === "OK") {
                alert("PIN entered: " + pinInput.value);
                return;
            }

            if (pinInput.value.length < 4) {
                pinInput.value += value;
            }
        });
    });

    // verify pin and complete transfer
    document.getElementById("verifyBtn").addEventListener("click", () => {
        if (pinInput.value.length === 4) {
            alert("Transfer Successful!\n\nBeneficiary: " + accountNumber.value + "\nAmount: AED " + amount.value);
            modal.style.display = "none";
            pinInput.value = "";

            accountNumber.value = "";
            amount.value = "";
        } else {
            alert("Enter 4-digit PIN");
        }
    });

});