document.addEventListener("DOMContentLoaded", () => {
    const editBtn = document.getElementById("editProfileBtn");
    const modal = document.getElementById("editModal");
    const closeModal = document.getElementById("closeModal");
    const pinInput = document.getElementById("pinInput");

    // open modal
    editBtn.addEventListener("click", () => {
        modal.style.display = "flex";
    });

    // close modal
    closeModal.addEventListener("click", () => {
        modal.style.display = "none";
        pinInput.value = "";
    });

    // Dialpad input
    document.querySelectorAll(".dial-btn").forEach(btn => {
        btn.addEventListener("click", () => {
            const value = btn.textContent;

            if (value === "C") {
                pinInput.value = "";
                return;
            }

            if (value === "OK") {
                alert("PIN entered: " + pinInput.value);
                return;
            }

            if (pinInput.value.length < 4) {
                pinInput.value += value;
            }
        });
    });

    // verify button
    document.getElementById("verifyBtn").addEventListener("click", () => {
        if (pinInput.value.length === 4) {
            alert("Verified! Proceed to change password.");
            modal.style.display = "none";
            pinInput.value = "";
        } else {
            alert("Enter 4-digit PIN");
        }
    });
});
