<?php
require 'auth/login-auth.php';  // <-- include the login logic
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Login | Dubai Treasury Bank</title>
    <link rel="stylesheet" href="css/auth.css">
</head>
<body>

    <div class="auth-container">
        <div class="auth-card">
            <div class="auth-top">
                <h2>Welcome Back</h2>
                <p>Login to your Dubai Treasury Bank account</p>
            </div>

            <form action="login.php" method="POST">

                <div class="input-group">
                    <label>Email or Phone</label>
                    <input type="text" name="login_user" placeholder="Enter your email or phone" required>
                </div>

                <div class="input-group">
                    <label>Password</label>
                    <div class="password-wrapper">
                        <input type="password" name="login_pass" placeholder="Enter your password" required>
                        <button class="show-btn" id="toggleLogin" type="button">Show</button>
                    </div>
                </div>

                <button type="submit" class="primary-btn" name="loginBtn">
                    Login
                </button>

            </form>

            <p class="auth-footer">
                Don’t have an account? <a href="signup.php">Create Account</a>
            </p>
        </div>
    </div>

    <script src="js/auth.js"></script>
</body>
</html>
