<?php
// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
?>


<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Dubai Treasury Bank - Dashboard</title>
    <link rel="stylesheet" href="css/middle-dashboard.css">
</head>

<body>

        <div class="top-header">
            <a href="dashboard.php" class="back-icon">
                <i class="bi bi-arrow-left"></i>
            </a>
            <h5></h5>
            <span></span>
        </div>

    <div class="dashboard-container">

        <!-- HEADER -->
        <header class="dash-header">
            <div class="logo">
                 Dubai Treasury Bank
            </div>
            <div class="header-right">
                <div class="last-login">
                    Last Login: <span id="lastLogin">12 Aug 2025, 09:30 AM</span>
                </div>
            </div>
        </header>

        <!-- BALANCE CARD -->
        <section class="balance-card">
            <div class="balance-top">
                <h2>Current Balance</h2>
                <span class="balance-amount" id="balanceAmount">AED 125,450.00</span>
            </div>
            <div class="balance-sub">
                <span>Available Balance</span>
                <span class="balance-status">Active</span>
            </div>
        </section>

        <!-- TRANSACTION LIST -->
        <section class="transaction-section">
            <div class="transaction-title">
                <h3>Last Transactions</h3>
                <span class="transaction-count">Showing 10 latest</span>
            </div>

            <div class="transaction-list" id="transactionList">
                <!-- Transactions will be generated by JS -->
            </div>
        </section>
    </div>

    <script src="js/middle-dashboard.js"></script>
</body>

</html>