<?php
// ----------------------------
// DATABASE CONNECTION
// ----------------------------
$host = "localhost";
$user = "root";
$password = "";
$dbname = "dubai_treasury_bank";

$conn = mysqli_connect($host, $user, $password, $dbname);

if (!$conn) {
    die("Connection failed: " . mysqli_connect_error());
}

// ----------------------------
// SIGNUP PROCESS
// ----------------------------
if (isset($_POST['signupBtn'])) {

    $fullName    = mysqli_real_escape_string($conn, $_POST['full_name']);
    $email       = mysqli_real_escape_string($conn, $_POST['email']);
    $phone       = mysqli_real_escape_string($conn, $_POST['phone']);
    $address     = mysqli_real_escape_string($conn, $_POST['address']);
    $dob         = mysqli_real_escape_string($conn, $_POST['dob']);
    $gender      = mysqli_real_escape_string($conn, $_POST['gender']);
    $nationality = mysqli_real_escape_string($conn, $_POST['nationality']);
    $kyc_status  = "Verified";
    $password    = mysqli_real_escape_string($conn, $_POST['password']);

    // Hash password
    $hashedPass = password_hash($password, PASSWORD_DEFAULT);

    // GENERATE ACCOUNT NUMBER (example: 10 digits)
    $account_number = rand(1000000000, 9999999999);

    // Insert query
    $sql = "INSERT INTO users (
        full_name, email, phone, password, account_number, account_balance,
        address, date_of_birth, gender, nationality, kyc_status
    ) VALUES (
        '$fullName', '$email', '$phone', '$hashedPass', '$account_number', 0.00,
        '$address', '$dob', '$gender', '$nationality', '$kyc_status'
    )";

    $result = mysqli_query($conn, $sql);

    if ($result) {
        echo "<script>alert('Signup successful!');</script>";
    } else {
        echo "<script>alert('Signup failed: " . mysqli_error($conn) . "');</script>";
    }
}

mysqli_close($conn);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Sign Up | Dubai Treasury Bank</title>
    <link rel="stylesheet" href="css/auth.css">
</head>
<body>

<div class="auth-container">
    <div class="auth-card">
        <div class="auth-top">
            <h2>Create Account</h2>
            <p>Sign up for Dubai Treasury Bank</p>
        </div>

        <form action="signup.php" method="POST">

            <div class="input-group">
                <label>Full Name</label>
                <input type="text" name="full_name" required>
            </div>

            <div class="input-group">
                <label>Email</label>
                <input type="email" name="email" required>
            </div>

            <div class="input-group">
                <label>Phone</label>
                <input type="text" name="phone" required>
            </div>

            <div class="input-group">
                <label>Address</label>
                <input type="text" name="address" required>
            </div>

            <div class="input-group">
                <label>Date of Birth</label>
                <input type="date" name="dob" required>
            </div>

            <div class="input-group">
                <label>Gender</label>
                <select name="gender" required>
                    <option value="">Select gender</option>
                    <option>Male</option>
                    <option>Female</option>
                    <option>Other</option>
                </select>
            </div>

            <div class="input-group">
                <label>Nationality</label>
                <input type="text" name="nationality" required>
            </div>

            <div class="input-group">
                <label>KYC Status</label>
                <input type="text" value="Verified" readonly>
            </div>

            <div class="input-group">
                <label>Password</label>
                <input type="password" name="password" required>
            </div>

            <button type="submit" class="primary-btn" name="signupBtn">
                Create Account
            </button>

        </form>

        <p class="auth-footer">
            Already have an account? <a href="login.php">Login</a>
        </p>
    </div>
</div>

</body>
</html>
