CREATE TABLE transactions (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,

    transaction_type ENUM(
        'Transfer',
        'Airtime',
        'Data',
        'Electricity',
        'Water',
        'Utility'
    ) NOT NULL,

    amount DECIMAL(15,2) NOT NULL,
    description VARCHAR(255),
    reference VARCHAR(50) UNIQUE,
    status ENUM('Success', 'Failed') DEFAULT 'Success',

    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,

    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
);
