CREATE TABLE users (
    id INT AUTO_INCREMENT PRIMARY KEY,

    full_name VARCHAR(100) NOT NULL,
    email VARCHAR(100) NOT NULL UNIQUE,
    phone VARCHAR(20) NOT NULL UNIQUE,

    password VARCHAR(255) NOT NULL,

    account_number VARCHAR(20) UNIQUE NOT NULL,
    account_balance DECIMAL(15,2) DEFAULT 0.00,

    address TEXT,
    date_of_birth DATE,
    gender ENUM('Male', 'Female', 'Other'),
    nationality VARCHAR(50),

    kyc_status ENUM('Verified', 'Pending') DEFAULT 'Verified',

    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);
