<?php
// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Transfer History - Dubai Treasury Bank</title>

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Custom CSS -->
    <link rel="stylesheet" href="css/middle-dashboard.css">
    <link rel="stylesheet" href="stlye_dash.css">
</head>

<body>

    <div class="dashboard-container">

        <!-- TOP HEADER -->
        <div class="top-header">
            <a href="dashboard.php" class="back-icon">
                <i class="bi bi-arrow-right"></i>
            </a>
            <h5>سجل التحويلات</h5>
            <span>Transfer History</span>
        </div>

        <!-- HEADER -->
        <header class="dash-header">
            <div class="logo">
                دبي تريجري بنك<br>
                <small>Dubai Treasury Bank</small>
            </div>

            <div class="header-right">
                <div class="last-login">
                    آخر تسجيل دخول<br>
                    <small>Last Login:</small>
                    <span id="lastLogin">12 Aug 2025, 09:30 AM</span>
                </div>
            </div>
        </header>

        <!-- BALANCE CARD -->
        <section class="balance-card">
            <div class="balance-top">
                <h2>الرصيد الحالي</h2>
                <small>Current Balance</small>
                <span class="balance-amount" id="balanceAmount">AED 125,450.00</span>
            </div>

            <div class="balance-sub">
                <span>
                    الرصيد المتاح<br>
                    <small>Available Balance</small>
                </span>
                <span class="balance-status">
                    نشط<br>
                    <small>Active</small>
                </span>
            </div>
        </section>

        <!-- TRANSACTION LIST -->
        <section class="transaction-section">
            <div class="transaction-title">
                <h3>آخر المعاملات</h3>
                <small>Recent Transactions</small>
                <span class="transaction-count">
                    عرض آخر 10 معاملات<br>
                    <small>Showing 10 latest</small>
                </span>
            </div>

            <div class="transaction-list" id="transactionList">
                <!-- Transactions generated by JS -->
            </div>
        </section>

    </div>

    <!-- Bottom Nav -->
<div class="bottom-nav">
    <div>
        <a href="dashboard.php"><i class="bi bi-house-fill active"></i></a>
        <a href="#"><i class="bi bi-bar-chart"></i></a>
        <a href="card.php"><i class="bi bi-credit-card"></i></a>
        <a href="user_details.php"><i class="bi bi-person"></i></a>
    </div>
</div>

    <script src="js/middle-dashboard.js"></script>
</body>

</html>
