<?php
// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
?>


<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Transfer | Dubai Treasury Bank</title>

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

    <!-- CSS -->
    <link rel="stylesheet" href="transfer.css">
</head>

<body>

    <div class="app">

        <!-- Header -->
        <div class="top-header">
            <a href="dashboard.php" class="back-icon">
                <i class="bi bi-arrow-left"></i>
            </a>
            <h5>Transfer / تحويل</h5>
            <span>Transfer money fast</span>
        </div>

        <div class="page-content">

            <!-- BALANCE CARD -->
            <div class="balance-card">
                <small>Available Balance</small>
                <h2>AED 125,450.00</h2>
            </div>

            <!-- BANK SELECTION -->
            <div class="form-card">
                <label>Select Bank / اختر البنك</label>
                <select id="bankSelect" class="form-control">
                    <option value="">Select Bank</option>
                    <option value="ADCB">Abu Dhabi Commercial Bank (ADCB)</option>
                    <option value="ADIB">Abu Dhabi Islamic Bank (ADIB)</option>
                    <option value="CBD">Commercial Bank of Dubai (CBD)</option>
                    <option value="DIB">Dubai Islamic Bank (DIB)</option>
                    <option value="FAB">First Abu Dhabi Bank (FAB)</option>
                    <option value="Mashreq">Mashreq Bank</option>
                    <option value="RAKBANK">RAKBANK</option>
                    <option value="Sharjah Islamic Bank">Sharjah Islamic Bank (SIB)</option>
                    <option value="Union">Union National Bank</option>
                    <option value="EmiratesNBD">Emirates NBD</option>
                    <option value="NoorBank">Noor Bank</option>
                    <option value="HSBC">HSBC UAE</option>
                    <option value="StandardChartered">Standard Chartered UAE</option>
                </select>
            </div>

            <!-- TRANSFER FORM -->
            <div class="form-card">
                <label>Beneficiary Account Number / رقم حساب المستفيد</label>
                <input id="accountNumber" class="form-control" placeholder="Enter account number">
            </div>

            <div class="form-card">
                <label>Amount (AED) / المبلغ</label>
                <input id="amount" class="form-control" placeholder="Enter amount">
            </div>

            <button class="primary-btn" id="continueBtn">Continue / متابعة</button>

        </div>

    </div>

    <!-- PIN MODAL -->
    <div class="modal-overlay" id="pinModal">
        <div class="modal">
            <div class="modal-header">
                <h5>Enter PIN / أدخل رقمك السري</h5>
                <span class="close-btn" id="closeModal">&times;</span>
            </div>

            <p class="modal-sub">Enter your 4-digit PIN to continue</p>

            <div class="input-group">
                <label>PIN</label>
                <input type="password" id="pinInput" maxlength="4" readonly>
            </div>

            <div class="dialpad">
                <button class="dial-btn">1</button>
                <button class="dial-btn">2</button>
                <button class="dial-btn">3</button>
                <button class="dial-btn">4</button>
                <button class="dial-btn">5</button>
                <button class="dial-btn">6</button>
                <button class="dial-btn">7</button>
                <button class="dial-btn">8</button>
                <button class="dial-btn">9</button>
                <button class="dial-btn">C</button>
                <button class="dial-btn">0</button>
                <button class="dial-btn">OK</button>
            </div>

            <button class="primary-btn modal-btn" id="verifyBtn">Verify / تأكيد</button>
        </div>
    </div>

    <!-- Bottom Nav -->
<div class="bottom-nav">
    <div>
        <a href="dashboard.php"><i class="bi bi-house-fill active"></i></a>
        <a href="#"><i class="bi bi-bar-chart"></i></a>
        <a href="card.php"><i class="bi bi-credit-card"></i></a>
        <a href="user_details.php"><i class="bi bi-person"></i></a>
    </div>
</div>

    <script src="js/transfer.js"></script>
</body>

</html>
