<?php
session_start();

// Database connection
$conn = mysqli_connect("localhost", "root", "", "dubai_treasury_bank");
if (!$conn) {
    die("Database connection failed");
}

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

// Fetch user details
$query = "SELECT * FROM users WHERE id = '$user_id' LIMIT 1";
$result = mysqli_query($conn, $query);

if (mysqli_num_rows($result) == 1) {
    $user = mysqli_fetch_assoc($result);
} else {
    echo "User not found";
    exit;
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تفاصيل المستخدم | بنك دبي للخزانة</title>

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

    <!-- CSS -->
    <link rel="stylesheet" href="user_detail.css">
</head>

<body>

    <div class="app">

        <!-- Header -->
        <div class="top-header">
            <a href="dashboard.php" class="back-icon">
                <i class="bi bi-arrow-left"></i>
            </a>
            <h5>تفاصيل المستخدم</h5>
            <span></span>
        </div>

        <div class="page-content">

            <!-- PROFILE CARD -->
            <div class="profile-card">
                <div class="profile-img">
                    <i class="bi bi-person-circle"></i>
                </div>
                <div class="profile-info">
                    <h4><?php echo $user['full_name']; ?></h4>
                    <p>رقم الحساب: <?php echo $user['account_number']; ?></p>
                    <p>نوع الحساب: Premium</p>
                </div>
            </div>

            <!-- USER DETAILS -->
            <div class="detail-card">
                <h6>المعلومات الشخصية</h6>
                <div class="detail-row">
                    <span><i class="bi bi-envelope"></i> البريد الإلكتروني</span>
                    <strong><?php echo $user['email']; ?></strong>
                </div>
                <div class="detail-row">
                    <span><i class="bi bi-phone"></i> الهاتف</span>
                    <strong><?php echo $user['phone']; ?></strong>
                </div>
                <div class="detail-row">
                    <span><i class="bi bi-geo-alt"></i> العنوان</span>
                    <strong><?php echo $user['address']; ?></strong>
                </div>
                <div class="detail-row">
                    <span><i class="bi bi-calendar"></i> تاريخ الميلاد</span>
                    <strong><?php echo $user['date_of_birth']; ?></strong>
                </div>
                <div class="detail-row">
                    <span><i class="bi bi-gender-male-female"></i> الجنس</span>
                    <strong><?php echo $user['gender']; ?></strong>
                </div>
                <div class="detail-row">
                    <span><i class="bi bi-flag"></i> الجنسية</span>
                    <strong><?php echo $user['nationality']; ?></strong>
                </div>
                <div class="detail-row">
                    <span><i class="bi bi-shield-lock"></i> حالة التحقق</span>
                    <strong class="status verified">
                        <?php echo ($user['kyc_status'] == "Verified") ? "تم التحقق" : "غير متحقق"; ?>
                    </strong>
                </div>
            </div>

            <!-- BALANCE CARD -->
            <div class="balance-card">
                <div>
                    <small>الرصيد المتاح</small>
                    <h2>AED <?php echo number_format($user['account_balance'], 2); ?></h2>
                </div>
                <button class="primary-btn">عرض المعاملات</button>
            </div>

            <!-- RECENT ACTIVITY -->
            <div class="activity-card">
                <h6>النشاط الأخير</h6>

                <!-- Example activity -->
                <div class="activity-row">
                    <div class="activity-icon"><i class="bi bi-arrow-up-right"></i></div>
                    <div>
                        <strong>تحويل</strong>
                        <p>تم إرسال 500 درهم</p>
                    </div>
                    <span class="amount">-AED 500</span>
                </div>
                <div class="activity-row">
                    <div class="activity-icon"><i class="bi bi-arrow-down-left"></i></div>
                    <div>
                        <strong>راتب</strong>
                        <p>تم استلام 2500 درهم</p>
                    </div>
                    <span class="amount">+AED 2,500</span>
                </div>
                <div class="activity-row">
                    <div class="activity-icon"><i class="bi bi-wallet2"></i></div>
                    <div>
                        <strong>سحب من الصراف</strong>
                        <p>تم سحب 200 درهم</p>
                    </div>
                    <span class="amount">-AED 200</span>
                </div>
            </div>

            <!-- ACTION BUTTONS -->
            <div class="action-buttons">
                <button class="secondary-btn" id="editProfileBtn">تعديل الملف الشخصي</button>
                <button class="primary-btn">تأكيد التحقق</button>
            </div>

        </div>

    </div>

    <!-- EDIT PROFILE MODAL -->
    <div class="modal-overlay" id="editModal">
        <div class="modal">
            <div class="modal-header">
                <h5>التحقق الأمني</h5>
                <span class="close-btn" id="closeModal">&times;</span>
            </div>

            <p class="modal-sub">أدخل تفاصيلك الأمنية لتغيير كلمة المرور</p>

            <div class="input-group">
                <label>أدخل رقم التعريف المكون من 4 أرقام</label>
                <input type="password" id="pinInput" maxlength="4" readonly>
            </div>

            <div class="dialpad">
                <button class="dial-btn">1</button>
                <button class="dial-btn">2</button>
                <button class="dial-btn">3</button>
                <button class="dial-btn">4</button>
                <button class="dial-btn">5</button>
                <button class="dial-btn">6</button>
                <button class="dial-btn">7</button>
                <button class="dial-btn">8</button>
                <button class="dial-btn">9</button>
                <button class="dial-btn">C</button>
                <button class="dial-btn">0</button>
                <button class="dial-btn">OK</button>
            </div>

            <button class="primary-btn modal-btn" id="verifyBtn">تأكيد</button>
        </div>
    </div>

    <!-- Bottom Navigation -->
<div class="bottom-nav">
    <div>
        <a href="user_details.php"><i class="bi bi-person active"></i></a>
        <a href="card.php"><i class="bi bi-credit-card"></i></a>
        <a href="#"><i class="bi bi-bar-chart"></i></a>
        <a href="dashboard.php"><i class="bi bi-house-fill"></i></a>
    </div>
</div>

    <!-- JS -->
    <script src="js/user_detail.js"></script>

</body>

</html>
